/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.access.AbstractArrowEntityAccess;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEEffects;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightingHandler {
    private static final Minecraft MinecraftInstance = Minecraft.m_91087_();
    public static final Map<BlockPos, LightData> LIGHT_SOURCES = new ConcurrentHashMap<BlockPos, LightData>();

    public static void tick(LivingEntity entity) {
        if (entity != null && DynamicLightingHandler.MinecraftInstance.f_91074_ != null && DynamicLightingHandler.MinecraftInstance.f_91074_.f_19797_ % (int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble() == 0) {
            if (DynamicLightingHandler.shouldGlow(entity)) {
                LIGHT_SOURCES.put(entity.m_20183_(), new LightData(DynamicLightingHandler.getTimeAmplifier(entity)));
            }
            if (entity == DynamicLightingHandler.MinecraftInstance.f_91074_) {
                LIGHT_SOURCES.forEach((pos, data) -> {
                    if (data.time == 0.0) {
                        data.shouldKeep = false;
                    }
                    if (data.time == 20.0 * data.amplifier || !data.shouldKeep) {
                        DynamicLightingHandler.MinecraftInstance.f_91073_.m_7726_().m_7827_().m_7174_(pos);
                    }
                    data.time -= (double)((int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble());
                });
                LIGHT_SOURCES.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldKeep);
            }
        }
    }

    public static void tick(AbstractArrow entity) {
        if (entity != null && DynamicLightingHandler.MinecraftInstance.f_91074_ != null && DynamicLightingHandler.MinecraftInstance.f_91074_.f_19797_ % (int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble() == 0 && DynamicLightingHandler.shouldGlow(entity)) {
            LIGHT_SOURCES.put(entity.m_20183_(), new LightData(0.5));
        }
    }

    public static int getTimeAmplifier(LivingEntity entity) {
        MobEffectInstance luminousEffect = entity.m_21124_((MobEffect)IEEffects.LUMINOUS.get());
        if (luminousEffect != null) {
            return luminousEffect.m_19564_() == 0 ? 1 : 2;
        }
        return 1;
    }

    public static boolean shouldGlow(AbstractArrow entity) {
        return ((AbstractArrowEntityAccess)entity).getGlow();
    }

    public static boolean shouldGlow(LivingEntity entity) {
        return entity.m_21023_((MobEffect)IEEffects.LUMINOUS.get());
    }

    public static class LightData {
        public boolean shouldKeep = true;
        public double time;
        public double amplifier;

        public LightData(double amplifier) {
            this.amplifier = amplifier;
            this.time = 20.0 * amplifier;
        }
    }
}

